
/** global vars **/

var canvas;
var context;
var mouseIsDown = false;
var lastPosition = [];
var currentColor = "blue";

window.onload = function()
{
	canvas = document.getElementById('c');
	context = canvas.getContext('2d');
	
	//set size
	canvas.width = window.innerWidth;
	canvas.height = window.innerHeight;
	
	//mouse events
	canvas.addEventListener('mousedown', onCanvasDown, false);
	canvas.addEventListener('mouseup', onCanvasUp, false);
	canvas.addEventListener('mousemove', onCanvasMove, false);
	
	
	this.touchEvents = new ConvertTouchEvents();
}


function onCanvasDown(e) {
	lastPosition = [e.pageX, e.pageY]
	mouseIsDown = true;
}

function onCanvasUp(e) {
	mouseIsDown = false;
}

function onCanvasMove(e){
	if	(mouseIsDown) {
	
		context.beginPath();
		context.moveTo(lastPosition[0], lastPosition[1]);
	
		context.lineTo(e.pageX, e.pageY);
		context.lineWidth = 5;
		context.strokeStyle = currentColor;
		context.lineCap = 'round';
		context.lineJoin = 'round';
		context.stroke();
		lastPosition = [e.pageX, e.pageY]
	}
}


function setColor(color)
{
	currentColor = color;
}
